function dim = numDim(x)
% DESCRIPTION:
%       Function to return the number of dimensions of a matrix x. Unlike
%       the inbuilt ndim, numDim returns 1 for single numeric values.
%
% USAGE:
%       dim = numDim(x)
%
% INPUTS:
%       x           - matrix with unknown number of dimensions
%
% OUTPUTS:
%       dim         - number of dimensions
%
% ABOUT:
%       author      - Bradley Treeby
%       date        - 29th April 2009
%       
% This function is part of the k-Wave Toolbox (http://www.k-wave.org)

sz = size(x);
if length(sz) > 2
    dim = length(sz);
elseif sz(1) == 1 || sz(2) == 1
    dim = 1;
else
    dim = 2;
end